﻿using Hims.Shared.EntityModels;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;

namespace Hims.Api.Senders
{
    /// <summary>
    /// The WhatsAppSMSSender Interface
    /// </summary>
    public interface IWhatsAppSMSSender
    {
        /// <summary>
        /// Sends the whats application message asynchronous.
        /// </summary>
        /// <param name="appointmentModel">The appointment model.</param>
        /// <param name="displayTime">The display time.</param>
        /// <param name="messageType">Type of the message.</param>
        /// <param name="location">The location.</param>
        /// <returns></returns>
        public Task<bool> SendWhatsAppMessageAsync(AppointmentModel appointmentModel, string displayTime, string messageType,string location);

        /// <summary>
        /// Sends the otp asynchronous.
        /// </summary>
        /// <param name="Mobile">The mobile.</param>
        /// <param name="Otp">The otp.</param>
        /// <returns></returns>
        public Task<bool> SendOTPAsync(string Mobile,string Otp);

        /// <summary>
        /// Sends the registered message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <returns></returns>
        public Task<bool> SendRegisteredMessage(string mobile, string fullName);

        /// <summary>
        /// Sends the lab booking whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="LabName">Name of the lab.</param>
        /// <returns></returns>
        public Task<bool> SendLabBookingWhatsAppMessage(string mobile, string fullName, string LabName);

        /// <summary>
        /// Sends the lab cancelling whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="LabName">Name of the lab.</param>
        /// <param name="requisitionNumber">The requisition number.</param>
        /// <returns></returns>
        public Task<bool> SendLabCancellingWhatsAppMessage(string mobile, string fullName, string LabName, string requisitionNumber);

        /// <summary>
        /// Sends the lab report whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="LabName">Name of the lab.</param>
        /// <param name="labLink">The lab link.</param>
        /// <returns></returns>
        public Task<bool> SendLabReportWhatsAppMessage(string mobile, string fullName, string LabName, string labLink);

        /// <summary>
        /// Sends the scan whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="scanName">Name of the scan.</param>
        /// <param name="scanDate">The scan date.</param>
        /// <param name="scanTime">The scan time.</param>
        /// <param name="type">The type.</param>
        /// <param name="requisitionNumber">The requisition number.</param>
        /// <returns></returns>
        public Task<bool> SendScanWhatsAppMessage(string mobile, string fullName, string scanName , string scanDate, string scanTime, string type, string requisitionNumber);

        /// <summary>
        /// Sends the pharmacy whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="type">The type.</param>
        /// <returns></returns>
        public bool SendPharmacyWhatsAppMessage(string mobile, string fullName, string type);

        /// <summary>
        /// Sends the lab precaution whats application message.
        /// </summary>
        /// <param name="mobile">The mobile.</param>
        /// <param name="fullName">The full name.</param>
        /// <param name="precautionText">The precaution text.</param>
        /// <returns></returns>
        public Task<bool> SendLabPrecautionWhatsAppMessage(string mobile, string fullName, string precautionText);
    }
}
